//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.4  Page 85 
//Title: Gravity Driven Flow from an IV Bottle

package Ex3_4
model Ex3_4_a

//=================
//Parameter Section
parameter Real h_a(unit = "m") = 1.2 "Height of IV bottle";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real Rho(unit = "kg/m3")= 1020 "Density of fluid";

//=================
//Variable Section 
Real Pgage_a(unit = "kPa") "Gage pressure of the blood";

//=================
//Equation Section
equation 
Pgage_a=(Rho*g*h_a)/1000; 
//Pgage_a is divided by 1000 to convert it to kPa

end Ex3_4_a;

//=================
model Ex3_4_b
extends Ex3_4_a;

//=================
//Parameter Section
parameter Real Pgage_b(unit = "kPa") = 20 "Gage pressure of the blood";

//=================
//Variable Section 
Real h_b(unit = "m") "Height of the surface of the IV fluid in the bottle from the arm level";

//=================
//Equation Section
equation 
h_b = (Pgage_b*1000)/(Rho*g);
//Multiplying Pgage by 1000 to convert kPa to Pa

end Ex3_4_b;
//=================

end Ex3_4;

//=================
