//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.6  Page 88 
//Title: Measuring Pressure with a Manometer

model Ex3_6

//=================
//Parameter Section
parameter Real SG(unit = "-") = 0.85 "Specific gravity of fluid";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real Rho_w(unit = "kg/m3")= 1000 "Density of water";
parameter Real h(unit="cm")= 55 "Height of manometer column";
parameter Real Patm(unit="kPa")= 96 "Local atmospheric pressure";

//=================
//Variable Section 
Real Pabs(unit = "kPa") "Absolute pressure within the tank";

//=================
//Equation Section
equation 
Pabs = Patm + ((Rho_w*SG*g*h*0.01)/1000); 
//Multiplying h by 0.01 to convert cm to m

end Ex3_6;
//=================
