//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.9  Page 99 
//Title: A Gravity-Controlled Cylindrical Gate

package Ex3_9
model Ex3_9_a
extends Modelica.Math;
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real R(unit = "m") = 0.8 "Radius of long solid cylinder";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real Rho(unit = "kg/m3")= 1000 "Density of water";
parameter Real s(unit = "m")= 4.2 "Water level";
parameter Real hb(unit = "m") = 5 "Level of water at the bottom";
parameter Real w(unit = "m") = 1 "Width of the fluid block";

//=================
//Variable Section 
Real F_H(unit = "kN") "Horizontal force on vertical surface";
Real F_y(unit = "kN") "Vertical force on horizontal surface (upward)";
Real W(unit = "kN") "Weight (downward) of fluid block for one m width into the page";
Real F_V(unit = "kN") "Net upward vertical force";
Real F_R(unit = "kN") "Magnitude of the hydrostatic force acting on the cylinder";
Real theta(unit = "degree") "Line of action passes through the center of the cylinder";
Real A(unit = "m2") "Area";

//=================
//Equation Section
equation 
A = R*1;
F_H = (Rho*g*(s+(R/2))*A)/1000;
F_y = (Rho*g*hb*A)/1000;
//Dividing F by 1000 to convert N to kN

W = (Rho*g*((R^2)-(pi*R^2/4))*w)/1000;
//Dividing W by 1000 to convert N to kN

F_V = F_y-W;
F_R = (F_H^2 + F_V^2)^(1/2);
theta = (atan(F_V/F_H))*(180/pi);
//Multiplying theta by (180/pi) to convert rad to degree

end Ex3_9_a;
//=================

model Ex3_9_b
extends Modelica.Math;
extends Ex3_9_a;

//=================
//Variable Section 
Real W_c(unit = "kN") "weight of the cylinder per m length of the cylinder";

//=================
//Equation Section
equation 
W_c = F_R*sin(theta);

end Ex3_9_b;

//The answer may slightly vary due to rounding off values

//=================

end Ex3_9;

//=================
