//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.13  Page 229
//Title:  Hydroelectric Power Generation from a Dam

model Ex5_13

//=================
//Parameter Section
parameter Real Rho_w(unit = "kg/m3") = 1000 "Density of water";
parameter Real V(unit = "kg/s") = 100 "Volumeteric flow rate";
parameter Real z1(unit = "m") = 120 "Elevation of water flow to a turbine";
parameter Real z2(unit = "m") = 0 "Elevation from reference level";
                                 //Reference level is taken as point 2
parameter Real hL(unit = "m") = 35 "Total irreversible head loss";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real Eff_tur(unit = "%") = 80 "Overall efficiency of the turbine–generator";

//=================
//Variable Section 
Real m(unit = "kg/s") "Mass flow rate of water through the turbine";
Real h_turbine(unit = "m") "Turbine head";
Real W_turbine(unit = "kW") "Turbine power";
Real W_electric(unit = "MW") "Electric power generated by the actual unit";

//=================
//Equation Section 
equation 
m = Rho_w*V;
h_turbine = z1-hL; 
//Reduced form of bernoulli equation

W_turbine = (m*g*h_turbine)/1000; 
//Dividing W_turbine by 1000 to convert W to kW

W_electric =(Eff_tur/100)*(W_turbine/1000); 

//Dividing Eff_tur by 100 to convert %
//Diving W_turbine by 1000 to convert kW to MW

end Ex5_13;

//=================
