//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.8  Page 215
//Title:  Velocity Measurement by a Pitot Tube

model Ex5_8

//=================
//Parameter Section
//From Figure 5-42, Page No.215
parameter Real h3(unit = "cm") = 12 "Water level in the pitot tube";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real V1(unit = "m/s") "Velocity at the center of the pipe";

//=================
//Equation Section 
equation 
V1 = sqrt(2*h3*0.01*g); 
//Multiplying h3 by 0.01 to convert cm to m

end Ex5_8;
//==================
