//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-7: Dimensional Analysis and Modeling 
//Example 7.5 Page 307 
//Title: Similarity between Model and Prototype Cars

model Ex7_5

//=================
//Parameter Section
//Prototype - The aerodynamic drag of a new sports car is predicted at an air temperature
//Model -  One-fifth scale model of the car to test in a wind tunnel temperature
parameter Real L_ratio(unit = "-") = 5 "Ratio of scaling"; //L_p/L_m
parameter Real V_p(unit = "mi/h") = 50 "Speed of the car prototype";
parameter Real T_p(unit = "C") = 25 "Temperature of the prototype";
parameter Real T_m(unit = "C") = 5 "Temperature of the model";

//Properties of air determined at the prototype temperature
parameter Real Rho_p(unit = "kg/m3") = 1.184 "Density of prototype";
parameter Real mu_p(unit = "kg/m s") = 1.849*0.00001 "Viscosity of protype";

//Properties of air determined at the model temperature
parameter Real Rho_m(unit = "kg/m3") = 1.269 "Density of model";
parameter Real mu_m(unit = "kg/m s") = 1.754*0.00001 "Viscosity of model";


//=================
//Variable Section 
Real V_m(unit = "mi/h") "Unknown wind tunnel speed for the model tests";

//=================
//Equation Section
equation 
V_m = V_p*(mu_m/mu_p)*(Rho_p/Rho_m)*L_ratio;

end Ex7_5;
//=================
