//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.12 Page 418
//Title: Blood Flow through the Aortic Bifurcation

model Ex8_12
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real kin_vis(unit = "cSt") = 4 "kinematic viscosity of blood";
parameter Real D3(unit = "mm") = 10 "Diameter of right common iliac artery";
parameter Real D1(unit = "mm") = 15 "Diameter of abdominal aorta";
parameter Real D2(unit = "mm") = 8 "Diameter of left common iliac artery";
parameter Real V1(unit = "cm/s") = 30 "Mean velocity of abdominal aorta";
parameter Real V2(unit = "cm/s") = 40 "Mean velocity of left common iliac artery";

//=================
//Variable Section 
Real V3(unit = "cm/s") "Mean velocity of right common iliac artery";
Real A1(unit = "cm2") "Area of abdominal aorta";
Real A2(unit = "cm2") "Area of left common iliac artery";
Real A3(unit = "cm2") "Area of right common iliac artery";

//=================
//Equation Section
equation 
//Using conservation of mass v1 = v2+v3  
//Flow rate of the abdominal aorta equals the sum of both common iliac arteries

A1 = (pi/4)*(D1*0.1)^2;
A2 = (pi/4)*(D2*0.1)^2;
A3 = (pi/4)*(D3*0.1)^2;
//Multiplying D by 0.1 to convert mm to cm

V3 = ((V1*A1)-(V2*A2))/(A3); 

end Ex8_12;
//=================
