//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.2 Page 364
//Title: Pumping Power Requirement for Oil Flow in a Pipe

model Ex8_2
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real Rho_o(unit = "kg/m3") = 894 "Density of oil";
parameter Real mu_o(unit = "kg/m.s") = 2.33 "Viscosity of oil";
parameter Real D(unit = "cm") = 28 "Diameter of the pipe";
parameter Real V(unit = "m/s") = 0.5 "Average velocity of oil";
parameter Real L(unit = "m") = 330 "Length of the pipeline";
String Flow;

//=================
//Variable Section 
Real v(unit = "m3/s") "Volume flow rate of oil"; 
Real Re(unit = "-") "Reynolds number";
Real f(unit = "-") "Friction factor";
Real Del_P(unit = "kPa") "Pressure drop in the pipe";
Real W_pump(unit = "kW") "Required pumping power";

//=================
//Equation Section
equation 
v = V*((pi/4)*(D*0.01)^2);
Re = Rho_o*V*D*0.01/mu_o;

//Condition checking for laminar 
if Re<2300
then 
Flow = "Laminar";
else 
Flow = "Turbulent";
end if;

f = 64/Re;
Del_P = f*(L/(D*0.01))*((Rho_o*(V^2))/2)*(1/1000);
W_pump = v*Del_P;

Modelica.Utilities.Streams.print(Flow);
 
end Ex8_2;
//=================
