//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.3 Page 374
//Title: Determining the Diameter of an Air Duct

model Ex8_3
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real L(unit = "m") = 150 "Length of circular duct";
parameter Real v(unit = "m3/s") = 0.35 "Volumetric flow rate";

//Properties of air determined at 1 atm and 35 C
parameter Real Rho_a(unit = "kg/m3") = 1.145 "Density of air";
parameter Real mu_a(unit = "kg/m.s") = 1.895*0.00001 "Dynamic viscosity of air";
parameter Real kv(unit = "m2/s") = 1.655*0.00001 "Kinematic viscosity of air";
parameter Real h_L(unit = "m") = 20 "Maximum head loss";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
String Flow;

//From Table 8-2, Page.No. 371
parameter Real RR(unit = "-") = 0 "Relative Roughness-ephisilon/D"; 

//=================
//Variable Section 
Real V(unit = "m/s") "Average velocity"; 
Real D_m1(unit = "m2") "Diameter of the duct using method-1";
Real D_m2(unit = "m2") "Diameter of the duct using method-2";
Real Re(unit = "-") "Reynolds number";
Real f(unit = "-") "Friction factor";

//=================
//Equation Section
equation 

//Method-1 : Iterative approach: Using Equation Solver
V = v/((pi/4)*(D_m1^2));
Re = (V*D_m1)/kv;

//Colebrook equation
1/sqrt(f)=-2*log10((2.51/(Re*sqrt(f))));
h_L = f*(L/D_m1)*((V^2)/(2*g));

//Check for Flow condition
if Re<2300
then 
Flow = "Laminar";
else 
Flow = "Turbulent";
end if;

Modelica.Utilities.Streams.print(Flow);

//Method-2 : Swamee–Jain relation
D_m2 = 0.66*((RR^1.25)+(kv*(v)^9.4)*(L/(g*h_L))^5.2)^0.04;

end Ex8_3;
//=================

