//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.7 Page 385
//Title: Head Loss and Pressure Rise during Gradual Expansion

model Ex8_7

//=================
//Parameter Section
parameter Real D1(unit = "cm") = 6 "Diameter of horizontal water pipe before expansion"; 
parameter Real D2(unit = "cm") = 9 "Diameter of horizontal water pipe after expansion";
parameter Real V1(unit = "m/s") = 7 "Average velocity of water before expansion";
parameter Real P1(unit = "kPa") = 150 "Pressure of water before expansion";
parameter Real Rho_w(unit = "kg/m3") = 1000 "Density of water";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//The flow at sections 1 and 2 is fully developed and turbulent ; alpha1=alpha2
parameter Real alpha(unit = "-") = 1.06 "Kinetic energy correction factor"; 

//From Table 8-4 Interpolation , Using angle = 20 degree and D1/D2
parameter Real K_L(unit = "-") = 0.133 "Loss coefficient" ;

//=================
//Variable Section 
Real V2(unit = "m/s") "Average velocity of water after expansion";
Real h_L(unit = "m") "Irreversible head loss in the expansion section";
Real P2(unit = "kPa") "Pressure of water after expansion";

//=================
//Equation Section
equation 

//From continuity equation
V2 = ((D1^2)/(D2^2))*V1;
h_L = K_L*(V1^2/(2*g));

//From reduced energy equation
P2 = P1+ ((Rho_w*alpha*((V1^2-V2^2)/2)-(g*h_L))/1000);
//Dividing by 1000 to convert Pa to kPa

end Ex8_7;
//=================

