//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.9 Page 392 
//Title: Gravity-Driven Water Flow in a Pipe

model Ex8_9
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real v(unit = "L/s") = 6 "Flow rate of water";
parameter Real D(unit = "cm") = 5 "Diameter of the pipe";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//Properties of water determined at 10 C
parameter Real Rho_w(unit = "kg/m3") = 999.7 "Density of water";
parameter Real mu_w(unit = "kg/m.s") = 1.307*0.001 "Dynamic viscosity of water";

//From Table 8–2, Page No.371
parameter Real e(unit = "m") = 0.00026 "Roughness of cast iron pipe"; 

//Upon Analysis From Figure 8-52, Page No. 392 
parameter Real KL_entrance(unit = "-") = 0.5 "Loss coeffecient at the sharp-edged entrance";
parameter Real KL_elbow(unit = "-") = 0.3 "Loss coeffecient at the flanged elbows";
parameter Real KL_valve(unit = "-") = 0.2 "Loss coeffecient at the fully open gate valve";
parameter Real KL_exit(unit = "-") = 1.06 "Loss coeffecient at the submerged exit";

//From Figure 8-52, Page No. 392
parameter Real L(unit = "m") = 89 "Length of the pipe";
parameter Real z2(unit = "m") = 4 "Elevation at point 2";
parameter Real nE(unit = "-") = 2 "Number of elbow";

//=================
//Variable Section 
Real V(unit = "m/s") "Average velocity in the pipe"; 
Real Re(unit = "-") "Reynolds number";
Real f(unit = "-") "Friction factor";
Real KL_sum(unit = "-") "Sum of loss coefficients";
Real h_L(unit = "m") "Total head loss";
Real z1(unit = "m") "Elevation of the source";
Real Ac(unit = "m2") "Area of the pipe";

//=================
//Equation Section
equation 
Ac = (pi/4)*(D*0.01)^2; 
//Multiplying D by 0.01 to convert cm to m

V = (v/1000)/Ac; 
//Dividing v by 1000 to convert L/s to m3/s

Re = (Rho_w*V*D*0.01)/mu_w; 
//Multiplying D by 0.01 to convert cm to m

//Colebrook equation 
1/sqrt(f)=-2*log10(((e/(D*0.01))/3.7)+(2.51/(Re*sqrt(f))));
//Multiplying D by 0.01 to convert cm to m

KL_sum = KL_entrance + (nE*KL_elbow) + KL_valve + KL_exit;
h_L = ((f*(L/(D*0.01)))+(KL_sum))*((V^2)/(2*g));
z1 = z2+h_L;

end Ex8_9;
//=================
