//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-10: Approximate Solutions of the Navier-Stokes Equation
//Example 10.10 Page 569
//Title: Laminar Boundary Layer on a Flat Plate

model Ex10_10
//Derivation of laminar boundary layer followed by an example in Page.572

//=================
//Parameter Section
parameter Real V(unit = "mi/h") = 20 "Speed of car on a hot day";
parameter Real x(unit = "ft") = 3.5 "Length of flat plate";
parameter Real KV(unit = "ft2/s") = 1.8*0.0001 "Kinematic viscosity of air";

//=================
//Variable Section 
Real Re(unit = "-") "Reynolds number";
Real del(unit = "in") "Thickness of the boundary layer";

//=================
//Equation Section
equation 
Re = ((V*x)/(KV))*(5280/3600); 
//Multiplying V by 5280 to convert mi/h to ft/h
//Dividing V by 3600 to convert ft/h to ft/s

/*Assuming the flow is laminar inspite of getting Re close to 
critical reynolds number, and using the laminar boundary layer equation*/

del = (4.91*x*12)/(sqrt(Re)); 
//Multiplying x by 12 convert ft to inch

//Answer may slightly vary from book answer value due to round off.

end Ex10_10;
//=================
