//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-10: Approximate Solutions of the Navier-Stokes Equation
//Example 10.11 Page 574
//Title: Displacement Thickness in the Design of a Wind Tunnel

model Ex10_11_a
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real V_beginning(unit = "m/s") = 4 "Speed of air at the beginning";
parameter Real x(unit = "cm") = 30 "Length of test section in the wind tunnel";
parameter Real KV(unit = "m2/s") = 1.507*0.00001 "Kinematic viscosity of air";
parameter Real D(unit = "cm") = 30 "Diameter of the test section in the wind tunnel";

//=================
//Variable Section 
Real Re(unit = "-") "Reynolds number";
Real del(unit = "mm") "Displacement thickness at the end of the test section";
String Flow;
Real V_end(unit = "m/s") "Average air speed at the end of the test section";
Real A_beginning(unit = "m2") "Area of the test section at the beginning";
Real A_end(unit = "m2") "Area of the test section at the end";
Real V_increase(unit = "%") "Percentage of increase in air speed through the test section";

//=================
//Equation Section
equation 
Re = ((V_beginning*x*0.01)/(KV)); 
//Multiplying x by 0.01 to convert cm to m
 
if Re>(5*10^5)
then
Flow = "Turbulent";
else 
Flow = "Laminar";
end if;

Modelica.Utilities.Streams.print(Flow);

del = (1.72*x*10)/(sqrt(Re)); 
//Multiplying x by 10 to convert cm to mm

//Applying conservation of mass 
A_beginning = pi*(D*0.01/2)^2; 
//Multiplying D by 0.01 to convert cm to m

A_end = pi*((D*0.01/2)-(del*0.001))^2; 
//Multiplying del by 0.001 to convert mm to m

V_end = V_beginning*(A_beginning/A_end);

//Due to the effect of displacement thickness
V_increase = ((V_end-V_beginning)/(V_end))*100;

end Ex10_11_a;
//=================
