//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-10: Approximate Solutions of the Navier-Stokes Equation
//Example 10.12 Page 578
//Title: Comparison of Laminar and Turbulent Boundary Layers

package Ex10_12
model Ex10_12_a

//=================
//Parameter Section
parameter Real V(unit = "m/s") = 10 "Velocity of air over a smooth flat plate";
parameter Real L(unit = "m") = 1.52 "Length of the flat plate";
parameter Real kv(unit = "m2/s") = 1.516*0.00001 "Kinematic viscosity of air at 20°C ";

//From Figure 10-113, Page No.577
parameter Real [6] R1(each unit = "-") = {0.2,0.4,0.6,0.8,1.0,1.2} "Ratio-1 (y/del)";
parameter Real [6] R2(each unit = "-") = {0.2,0.4,0.6,0.8,1.0,1.2} "Ratio-2 (u/V)";

//=================
//Variable Section 
Real Re_x_a(unit = "-") "Reynolds number";
Real x_a(unit = "m") "Length";
Real Del_lam_a(unit = "mm") "Boundary layer thickness for the laminar case";
Real Del_tur_a(unit = "mm") "Boundary layer thickness for the turbulent case";
Real [6] y_L(each unit = "mm") "Distance for laminar profile";
Real [6] u_L(each unit = "m/s") "Velocity for laminar profile";
Real [6] y_T(each unit = "mm") "Distance for turbulent profile";
Real [6] u_T(each unit = "m/s") "Velocity for turbulent profile";

//=================
//Equation Section
equation 
x_a = L;
Re_x_a = V*x_a/kv;
Del_lam_a = ((4.91*x_a)/(sqrt(Re_x_a)))*(10^3); 
//Multiplying by 10^3 to x from convert m to mm

Del_tur_a = ((0.16*x_a)/(Re_x_a^(1/7)))*(10^3); 
//Multiplying by 10^3 to x from convert m to mm

//For Ploting u as function of y

//Laminar Profile
for i in 1:6 loop
y_L[i] = R1[i]*Del_lam_a;
u_L[i] = R2[i]*V;
end for;

//Turbulent Profile
for i in 1:6 loop
y_T[i] = R1[i]*Del_tur_a;
u_T[i] = R2[i]*V;
end for;

end Ex10_12_a;
//=================

model Ex10_12_b
extends Ex10_12_a;

//=================
//Variable Section 
Real Cfx_lam(unit = "-") "Local skin friction coefficient for the laminar case";
Real Cfx_tur(unit = "-") "Local skin friction coefficient for the turbulent case";

//=================
//Equation Section
equation 
Cfx_lam = (0.664)/(sqrt(Re_x_a));
Cfx_tur = (0.027)/(Re_x_a^(1/7));

end Ex10_12_b;
//=================

model Ex10_12_c
extends Ex10_12_a;
extends Ex10_12_b;

//=================
//Parameter Section
//Input given to generate the comparison plot
parameter Real [6] x_b(each unit = "m") = {0.2,0.4,0.6,0.8,1.0,1.5} "Length of flat plate";

//=================
//Variable Section 
Real [6] Re_x_b(each unit = "mm") "Distance for laminar profile";
Real [6] Del_lam_b(each unit = "mm") "Laminar boundary layer thickness";
Real [6] Del_tur_b(each unit = "mm") "Turbulent boundary layer thickness";

//=================
//Equation Section
equation 

/*For Plotting Comparison of the growth of a
laminar boundary layer and a turbulent boundary layer for the flat plate*/

for i in 1:6 loop
Re_x_b[i] = V*x_b[i]/kv;
Del_lam_b[i] = ((4.91*x_b[i])/(sqrt(Re_x_b[i])))*(10^3); 
//Multiplying by 10^3 to x from convert m to mm

Del_tur_b[i] = ((0.16*x_b[i])/(Re_x_b[i]^(1/7)))*(10^3); 
//Multiplying by 10^3 to x from convert m to mm

end for;

end Ex10_12_c;
//=================

end Ex10_12;

//=================
