//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-10: Approximate Solutions of the Navier-Stokes Equation
//Example 10.13 Page 581
//Title: Comparison of Turbulent Boundary Layer Profile Equations

model Ex10_13

//=================
//Parameter Section
parameter Real kv(unit = "m2/s") = 1.516*0.00001 "Kinematic viscosity of air at 20°C ";
parameter Real V(unit = "m/s") = 10 "Velocity of air over a smooth plate";
parameter Real L(unit = "m") = 15.2 "Length of smooth plate";

//u varies from 0 to V (Limit)
parameter Real [5] U(each unit = "m/s") = {2,4,6,8,10}"Velocity of air over a smooth plate";

//Constants - Referred from Page No.580
parameter Real k(unit = "-") = 0.4 "Constant-1";
parameter Real B(unit = "-") = 5.0 "Constant-2";

//=================
//Variable Section 
Real Re(unit = "-") "Reynolds number";
Real Del(unit = "m") "Boundary layer thickness";
Real Cf_x(unit = "-") "Local skin friction coefficient at the end of the plat";
Real Us(unit = "m/s") "Friction velocity";
Real x(unit = "m") "Length of the smooth plate";
Real [5] y(each unit = "mm") "Length";

//=================
//Equation Section
equation 
L = x;
Re = (V*x)/(kv);
Del = (0.16*x)/(Re^(1/7));
Cf_x = 0.027/(Re^(1/7));
Us = V*sqrt(Cf_x/2);

//For Generating the Plot
for i in 1:5 loop
y[i] = (kv/Us*(10^3))*exp(k*((U[i]/Us)-B));
end for;

end Ex10_13;
//=================
