//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-10: Approximate Solutions of the Navier-Stokes Equation
//Example 10.15 Page 591
//Title: Drag on the Wall of a Wind Tunnel Test Section

model Ex10_15

//=================
//Parameter Section
parameter Real del_1(unit = "cm") = 4.2 "Boundary layer thickness at 1";
parameter Real del_2(unit = "cm") = 7.7 "Boundary layer thickness at 2";
parameter Real V(unit = "m/s") = 10 "Velocity of air";
parameter Real w(unit = "m") = 0.5 "Width of test section";

//Properties of air estimated at 20 C
parameter Real Rho_a(unit = "kg/m3") = 1.204 "Density of air";
parameter Real kv(unit = "m2/s") = 1.516*0.00001 "Kinematic viscosity of air";

//=================
//Variable Section 
Real FD(unit = "N") "Drag force";

//=================
//Equation Section
equation 

//Using the equation which is obtained from intergration
FD = w*Rho_a*V^2*(4/45)*(del_2-del_1)*0.01;

end Ex10_15;
//=================
