//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-11: External Flow: Drag and Lift    
//Example 11.1  Page 617
//Title:  Measuring the Drag Coefficient of a Car

model Ex11_1

//=================
//Parameter Section
parameter Real A(unit = "ft2") = 22.26 "Frontal area of the car";
parameter Real Rho_a(unit = "lbm/ft3") = 0.07489 "Density of air at 1 atm, 70 F";
parameter Real F_D(unit = "lbf") = 68 "Drag force acting on the car";
parameter Real V(unit = "mi/h") = 60 "Velocity of the car";

//=================
//Variable Section 
Real C_D(unit = "-") "Drag coefficient of the car";

//=================
//Equation Section 
equation 
C_D = (2*F_D*32.2)/(Rho_a*A*((V*1.467)^2)); 
//Multiplying V by 1.467 to convert mi/h to ft/s
//Multiplying F_D by 32.2 to convert lbm to lbf

end Ex11_1;
//==================
