//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-11: External Flow: Drag and Lift    
//Example 11.2  Page 627
//Title:  Effect of Frontal Area on Fuel Efficiency of a Car

model Ex11_2

//=================
//Parameter Section
parameter Real C_D(unit = "-") = 0.3 "Drag coefficient of the car";
parameter Real W(unit = "m") = 1.85 "Width of the car";
parameter Real H(unit = "m") = 1.70 "Height of the car";
parameter Real Rho_a(unit = "kg/m3") = 1.20 "Density of air";
parameter Real Rho_g(unit = "kg/L") = 0.74 "Density of gasoline";
parameter Real V(unit = "km/h") = 95 "Average speed of the car";
parameter Real L(unit = "km") = 18000 "Distance covered by the car in a year";
parameter Real UC_g(unit = "$/L") = 0.95 "Unit cost of gasoline";
parameter Real HV(unit = "kJ/kg") = 44000 "Heating value of gasoline";
parameter Real Hnew(unit = "m") = 1.55 "Reduction in height of the car";
parameter Real Eff(unit = "%") = 30 "Overall efficiency of the car’s drive train";


//=================
//Variable Section 
Real A(unit = "m2") "Area of the car";
Real F_D(unit = "N") "Drag force acting on the car before redesigning";
Real W_D(unit = "kJ/year") "Amount of work done to overcome the drag force";
Real E_in(unit = "kJ/year") "Required energy input";
Real A_F(unit = "L/year") "Amount of fuel";
Real C_F(unit = "$/year") "Cost of fuel";
Real Rr(unit = "-") "Reduction ratio";
Real F_r(unit = "L/year") "Fuel reduction";
Real C_r(unit = "$/year") "Cost reduction";


//=================
//Equation Section 
equation 
A = H*W;
F_D = (C_D*A*Rho_a*(V^2))/(3.6^2*2); 
//Dividing V by 3.6 to convert km/h to m/s

W_D = F_D*L*((1000*1)/(1000*1));
E_in = W_D/(Eff/100);
A_F = (E_in/HV)/(Rho_g);
C_F = A_F*UC_g;
Rr = (H-Hnew)/H;
F_r = Rr*A_F;
C_r = Rr*C_F;


end Ex11_2;
//==================
