//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-11: External Flow: Drag and Lift    
//Example 11.4  Page 637
//Title:  Drag Force Acting on a Pipe in a River

model Ex11_4

//=================
//Parameter Section
parameter Real Rho_w(unit = "kg/m3") = 999.1 "Density of water at 15 C";
parameter Real mu(unit = "kg/m s") = 1.138*0.001 "Dynamic viscosity of water at 15 C";
parameter Real D(unit = "cm") = 2.2 "Outer diameter of the pipe";
parameter Real V(unit = "m/s") = 4 "Average flow velocity of the water";
parameter Real W(unit = "m") = 30 "Width of the pipe across the river";

//=================
//Variable Section 
Real A(unit = "m2") "Area of the pipe";
Real C_D(unit = "-") "Drag coefficient of the pipe";
Real Re(unit = "-") "Reynolds number";
Real F_D(unit = "N") "Drag force acting on the pipe";

//=================
//Equation Section 
equation 
A = W*(D*0.01); 
//Multiplying D by 0.01 to convert cm to m;

Re = Rho_w*V*(D*0.01)/mu; 
//Multiplying D by 0.01 to convert cm to m;

C_D = 1.0; 
//From Figure 11-34 Page no 635, corresponding to Reynolds number;

F_D = C_D*A*Rho_w*V^2/2;

end Ex11_4;
//==================
