//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-11: External Flow: Drag and Lift    
//Example 11.5  Page 644
//Title: Lift and Drag of a Commercial Airplane

package Ex11_5
model Ex11_5_a

//=================
//Parameter Section
parameter Real m(unit = "kg") = 70000 "Total mass in commercial airplane";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real V(unit = "km/h") = 558 "Cruising speed of plane";
parameter Real Rho_ag(unit = "kg/m3") = 1.20 "Density of air on the ground";
parameter Real Rho_aa(unit = "kg/m3") = 0.312 "Density of air at the cruisig altitude";
parameter Real CL_max1(unit = "-") = 1.52 "Maximum lift coefficient of the wing without flaps";
                                  //From Figure 11-45, Page no.641
parameter Real CL_max2(unit = "-") = 3.48 "Maximum lift coefficient of the wing with flaps";
                                  //From Figure 11-45, Page no.641
parameter Real A(unit = "m2") = 150 "Wing planform area";
parameter Real h(unit = "m") = 12000 "Cruising altitude of plane";

//=================
//Variable Section 
Real W(unit = "N") "Weight of the airplane";
Real V_c(unit = "m/s") "Converted V_c from km/h to m/s";
Real V_min1(unit = "m/s") "Minimum velocity without flaps";
Real V_min2(unit = "m/s") "Minimum velocity with flaps";
Real V_min1_safe(unit = "m/s") "Safe minimum velocities to avoid the stall region without flaps";
Real V_min2_safe(unit = "m/s") "Safe minimum velocities to avoid the stall region with flaps";
Real V_min1_safe_c(unit = "km/h") "Converted velocity from m/s to km/h";
Real V_min2_safe_c(unit = "km/h") "Converted velocity from m/s to km/h";


//=================
//Equation Section 
equation 
W = m*g;
V_c = V/3.6 ; 
//Dividing V by 3.6 to convert km/h to m/s;

V_min1 = sqrt((2*W)/(Rho_ag*CL_max1*A));
V_min2 = sqrt((2*W)/(Rho_ag*CL_max2*A));
V_min1_safe = 1.2*V_min1;
V_min1_safe_c = V_min1_safe*3.6; 
//Multiplying V_min1_safe by 3.6 to convert m/s to km/h;

V_min2_safe = 1.2*V_min2;

V_min2_safe_c = V_min2_safe*3.6;
//Multiplying V_min2_safe by 3.6 to convert m/s to km/h;

end Ex11_5_a;
//==================

model Ex11_5_b
extends Ex11_5_a;

//==================
//Variable Section 
Real F_L(unit = "N") "Lift";
Real C_L(unit = "-") "Lift coefficient";
Real Alpha(unit = "degree") "Angle of attack to cruise steadily at the cruising altitude";

//=================
//Equation Section 
equation 
F_L = W; 
//Aircraft is cruising steadily at a constant altitude

C_L = F_L / ((1/2)*Rho_aa*V_c^2*A);

//From Figure 11-45 , Page no.641; Corresponding to C_L;
Alpha = 10; 

end Ex11_5_b;
//==================

model Ex11_5_c
extends Ex11_5_a;

//=================
//Parameter Section
parameter Real C_D(unit = "-") = 0.03 "Drag coefficient corresponding to the cruising lift coefficient";
                               //From Figure 11-45 , Page no.641; Corresponding to C_L
                               
                               
//==================
//Variable Section
Real F_D(unit = "kN") "Drag force acting on the wings";
Real P(unit = "kW") "Power that needs to be supplied to provide enough thrust to overcome wing drag";
 
//=================
//Equation Section 
equation 
F_D = (C_D*A*Rho_aa*V_c^2)/(2*1000);
P = F_D*V_c;

end Ex11_5_c;

//==================

end Ex11_5;

//==================

