//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.14  Page 709
//Title: Rayleigh Flow in a Tubular Combustor

model Ex12_14
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real Cp(unit = "kJ/kg K") = 1.005 "Specific heat capacity";
parameter Real R(unit = "kJ/kg K") = 0.287 "Gas constant";
parameter Real k(unit = "-") = 1.4 "Specific heat ratio";
parameter Real T1(unit = "K") = 550 "Inlet temperature of the compressed air";
parameter Real P1(unit = "kPa") = 480 "Inlet pressure of the compressed air";
parameter Real V1(unit = "m/s") = 80 "Inlet velocity of the compressed air";
parameter Real AF(unit = "-") = 40 "Air–fuel mass ratio";
parameter Real HV(unit = "kJ/kg") = 42000 "Heating value of fuel";
parameter Real D(unit = "cm") = 15 "Diameter of tubular combustor";
                 
//=================
//Variable Section 
Real Rho_1(unit = "kg/m3") "Inlet density of air";
Real m_air(unit = "kg/s") "Mass flow rate of air";
Real m_fuel(unit = "kg/s") "Mass flow rate of fuel";
Real Q(unit = "kW") "Rate of heat transfer";
Real q(unit = "kJ/kg") "Inlet energy";
Real T01(unit = "K") "Stagnation temperature";
Real c1(unit = "m/s") "Speed at inlet";
Real Ma1(unit = "-") "Mach number at the inlet";
Real Ma2(unit = "-") "Mach number at the outlet";
Real T02(unit = "K") "Exit Stagnation temperature";
Real T0S(unit = "K") "Maximum value of stagnation temperature";
Real TR0(unit = "-") "Ratio of temperature at Ma1";
Real TR1(unit = "-") "Ratio of temperature at inlet mach number";
Real TR2(unit = "-") "Ratio of temperature at exit mach number";
Real PR1(unit = "-") "Ratio of pressure at inlet mach number";
Real PR2(unit = "-") "Ratio of pressure at exit mach number";
Real VR1(unit = "-") "Ratio of velocity at inlet mach number";
Real VR2(unit = "-") "Ratio of velocity at exit mach number";
Real T2(unit = "K") "Exit temperature";
Real P2(unit = "kPa") "Exit pressure";
Real V2(unit = "m/s") "Exit velocity";

//=================
//Equation Section 
equation 
Rho_1 = P1/(R*T1);

m_air = Rho_1*((pi/4)*(D*0.01)^2)*V1;
//Multiplying D by 0.01 to convert cm to m

m_fuel = m_air/AF;
Q = m_fuel*HV;
q = Q/m_air;
T01 = T1 + ((V1^2)/(2*Cp*1000));
c1 = sqrt(k*R*T1*1000);
Ma1 = V1/c1;
T02 = T01 + (q/Cp);

//Ratios taken from Table-A15 corresponding to inlet and exit mach number
TR0 = 0.1291;
TR1 = 0.1541;
TR2 = 0.4389;
PR1 = 2.3065;
PR2 = 2.1086;
VR1 = 0.0668;
VR2 = 0.2082;

T0S = T01/TR0;
Ma2 = T02/T0S;

//Exit temperature, pressure, and velocity determined from ratios
T2 = (TR2/TR1)*T1;
P2 = (PR2/PR1)*P1;
V2 = (VR2/VR1)*V1;

end Ex12_14;

//==================
