//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.2  Page 671
//Title: Gas Flow through a Converging–Diverging Duct

model Ex12_2

//=================
//Parameter Section
parameter Real T0(unit = "C") = 200 "Stagnation temperature";
parameter Real P0(unit = "kPa") = 1400 "Stagnation pressure";
parameter Real PD(unit = "kPa") = 200 "Pressure drop at first location";
parameter Real Cp(unit = "kJ/kg K") = 0.846 "Specific heat capacity of CO2 at room temperature";
parameter Real k(unit = "-") = 1.289 "Specific heat ratio of CO2 at room temperature";
parameter Real R(unit = "kJ/kg K") = 0.1889 "Gas constant of carbon dioxide";
parameter Real m(unit = "kg/s") = 3 "Mass flow rate of CO2";

//=================
//Variable Section 
Real T(unit = "K") "Temperature at the exit";
Real P(unit = "kPa") "Pressure at the exit";
Real V(unit = "m/s") "Velocity of CO2";
Real Rho(unit = "kg/m3") "Density of CO2";
Real A(unit = "cm2") "Area";
Real Ma(unit = "-") "Mach number";
Real c(unit = "m/s") "Speed of sound";

//=================
//Equation Section 
equation 
P = PD+1000; //Adding 1000 with ref From Figure 12-6, Page no-671

T = (T0+273)*((P/P0)^((k-1)/(k))); 
V = sqrt(2*Cp*((T0+273)-T)*1000);
//Adding 273 to T0 to convert C to K

Rho = P/(R*T);
A = (m/(Rho*V))*10^4;
//Multiplying A by 10^4 to convert m2 to cm2

c = sqrt(k*R*T*1000);
Ma = V/c;

end Ex12_2;
//==================
