//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.3  Page 677
//Title: Critical Temperature and Pressure in Gas Flow

model Ex12_3

//=================
//Parameter Section
parameter Real T0(unit = "C") = 200 "Stagnation temperature";
parameter Real P0(unit = "kPa") = 1400 "Stagnation pressure";
parameter Real k(unit = "-") = 1.289 "Specific heat ratio of CO2 at room temperature";

//=================
//Variable Section 
Real T_R(unit = "-") "Ratio of critical to stagnation temperature"; //T_R = T*/T0
Real P_R(unit = "-") "Ratio of critical to stagnation pressure"; //P_R = P*/P0
Real T_C(unit = "K") "Critical temperature";
Real P_C(unit = "kPa") "Critical pressure";

//=================
//Equation Section 
equation 
T_R = 2/(k+1);
P_R =(2/(k+1))^((k)/(k-1));

T_C = T_R*(T0+273); 
//Adding 273 to Convert T0 from C to K

P_C = P_R*P0;

end Ex12_3;
//==================
