//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.6  Page 684
//Title: Airflow through a Converging–Diverging Nozzle

package Ex12_6
model Ex12_6_a

//=================
//Parameter Section
parameter Real T0(unit = "K") = 800 "Temperature of air at the inlet of nozzle";
parameter Real P0(unit = "MPa") = 1.0 "Pressure at the inlet of nozzle";
parameter Real k(unit = "-") = 1.4 "Specific heat ratio of air";
parameter Real R(unit = "kJ/kg⋅K") =  0.287 "Gas constant of air";
parameter Real A_T(unit = "cm2") = 20 "Throat area";
parameter Real Ma(unit = "-") = 2 "Mach number at the exit";

//Since Ma = 1 at the throat of nozzle, Ratios are taken from Table A–13, Page no: 961
parameter Real P_R1(unit = "-") = 0.5283 "Pressure ratio"; //P_R1 = P_C/P0
parameter Real T_R1(unit = "-") = 0.8333 "Temperature ratio"; //T_R1 = T_C/T0
parameter Real Rho_R1(unit = "-") = 0.6339 "Density ratio"; //Rho_R1 = Rho_C/Rho_0

//=================
//Variable Section 
Real Rho_0(unit = "kg/m3") "Stagnation density";
Real P_C(unit = "MPa") "Critical Pressure";
Real T_C(unit = "K") "Critical Temperature";
Real Rho_C(unit = "kg/m3") "Critical density";
Real V_C(unit = "m/s") "Velocity of air at the throat";

//=================
//Equation Section 
equation 
//Throat conditions
Rho_0 = (P0*1000)/(R*T0); 
//Multiplying P0 by 1000 to convert MPa to Pa;

P_C = P_R1*P0;
T_C = T_R1*T0;
Rho_C = Rho_R1*Rho_0;
V_C = sqrt(k*R*T_C*1000);

end Ex12_6_a;


//==================
model Ex12_6_b
extends Ex12_6_a;

//=================
//Parameter Section
//Since Ma = 2 at the exit, Ratios are taken from Table A–13, Page no: 961
parameter Real P_R2(unit = "-") = 0.1278  "Pressure ratio"; //P_R2 = P_e/P0
parameter Real T_R2(unit = "-") = 0.5556 "Temperature ratio"; //T_R2 = T_e/T0
parameter Real Rho_R2(unit = "-") = 0.2300 "Density ratio"; //Rho_R2 = Rho_e/Rho_0
parameter Real A_R2(unit = "-") = 1.6875 "Area ratio"; //A_R2 = A_e/A_T
parameter Real Ma_e(unit = "-") = 1.6330 "Mach number at the exit";

//=================
//Variable Section 
Real P_e(unit = "MPa") "Pressure at the exit";
Real T_e(unit = "K") "Temperature at the exit";
Real Rho_e(unit = "kg/m3") "Density at the exit";
Real V_e(unit = "m/s") "Velocity of air at the exit";
Real A_e(unit = "cm2") "Exit area of nozzle";

//=================
//Equation Section 
equation 
//Exit plane conditions
P_e = P_R2*P0;
T_e = T_R2*T0;
Rho_e = Rho_R2*Rho_0;
A_e = A_R2*A_T;
V_e = Ma_e*V_C;

//==================
end Ex12_6_b;

//==================

model Ex12_6_c
extends Ex12_6_a;

//=================
//Variable Section 
Real m(unit = "kg/s") "Mass flow rate through the nozzle";

//=================
//Equation Section 
equation 
//Since the flow is steady, the mass flow rate of the fluid is the same at all sections of the nozzle.
//Thus it may be calculated by using properties at any cross section of the nozzle.
m = Rho_C*A_T*0.0001*V_C; 
//Multiplying A_T by 0.0001 to convert cm2 to m2;

end Ex12_6_c;

//==================

end Ex12_6;

//==================
