//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-12: Compressible Flow  
//Example 12.9  Page 698
//Title: Estimation of the Mach Number from Mach Lines

model Ex12_9
extends Modelica.Math;
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real mu(unit = "degree") = 19 "Angle of the Mach lines in the free-stream flow"; 
                  //From Figure 12–32, Page no 698

//=================
//Variable Section 
Real Ma(unit = "-") "Mach number of the free-stream flow upstream of the space shuttle";


//=================
//Equation Section 
equation 
Ma = (1/(sin(mu*pi/180)));
//Multiplying mu by (pi/180) to convert degree to radian

end Ex12_9;
//==================
