//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.1 Page 743
//Title: Character of Flow and Alternate Depth

model Ex13_1

//=================
//Parameter Section
parameter Real b(unit = "m") = 0.4 "Width of rectangular open channel";
parameter Real v(unit = "m3/s") = 0.2 "Flow rate of water";
parameter Real y(unit = "m") = 0.15 "Flow depth";
parameter Real g(unit = "m2/s") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real V(unit = "m/s") "Average flow velocity";
Real y_c(unit = "m") "Critical depth for the flow";
Real Fr(unit = "-") "Froude number";
Real E_s1(unit = "m") "Specific energy";
Real E_s2(unit = "m") "Specific energy";
Real y_1(unit = "m") "Given flow depth";
Real y_2(unit = "m") "Alternate flow depth if the character of flow were to change";
String Character_of_Flow_by_Method_a;
String Character_of_Flow_by_Method_b;

//=================
//Equation Section 
equation 
V = v/(y*b);
y_c = ((v^2)/(g*(b^2)))^(1/3);
Fr = V/sqrt(g*y);


//Determining the Character of Flow
//Method-a

if y<y_c then
Character_of_Flow_by_Method_a = "Supercritical";
else
Character_of_Flow_by_Method_a = "Subcritical";
end if;

Modelica.Utilities.Streams.print(Character_of_Flow_by_Method_a);

//Method-b
if Fr>1 then
Character_of_Flow_by_Method_b = "Supercritical";
else
Character_of_Flow_by_Method_b = "Subcritical";
end if;

Modelica.Utilities.Streams.print(Character_of_Flow_by_Method_b);

y = y_1;
E_s1 = y_1 + (((v^2))/(2*g*(b^2)*(y_1^2)));
E_s1 = E_s2; //Specific energy is constant
E_s2 = y_2 + (((v^2))/(2*g*(b^2)*(y_2^2)));

end Ex13_1;
//==================
