//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.10 Page 777
//Title: Subcritical Flow over a Bump

model Ex13_10

//=================
//Parameter Section
parameter Real y_1(unit = "m") = 0.8 "Depth of flow before the bump";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real V_1(unit = "m/s") = 1.2 "Velocity of water before the bump";
parameter Real del_zb(unit = "cm") = 15 "Height of bump at the bottom of the channel";

//=================
//Variable Section 
Real Fr_1(unit = "-") "Upstream Froude number";
Real y_c(unit = "m") "Critical depth";
Real E_s1(unit = "m") "Upstream specific energy";
Real y_2(unit = "m") "Flow depth over the bump";
Real depression(unit = "m") "Amount of depression over the bump";
String Character_of_Flow;

//=================
//Equation Section 
equation 
Fr_1 = V_1/(sqrt(g*y_1));
y_c = (((y_1^2)*(V_1^2))/(g))^(1/3);

//Determining the Character of Flow
if Fr_1>1 then
Character_of_Flow = "Supercritical";
else
Character_of_Flow = "Subcritical";
end if;

Modelica.Utilities.Streams.print(Character_of_Flow);

E_s1 = y_1+((V_1^2)/(2*g));
(y_2^3)-((E_s1-(del_zb*0.01))*(y_2^2))+(((V_1^2)/(2*g))*(y_1^2)) = 0;

depression = y_1-(y_2+(del_zb*0.01)); 
//Multiplying del_zb by 0.01 to convert cm to m

end Ex13_10;
//==================
