//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.4 Page 750
//Title: Channels with Nonuniform Roughness

model Ex13_4

//=================
//Parameter Section
parameter Real S0(unit = "-") = 0.003 "Bottom slope in the channel";
parameter Real a(unit = "m^(1/3)/s") = 1 "Dimensional constant";

//From Figure 13-21, Page No.750

//Subsection-1: Clean natural channel 
parameter Real h1(unit = "m") = 3 "Height of the channel";
parameter Real h2(unit = "m") = 2 "Height of the channel";
parameter Real w1(unit = "m") = 6 "Width of the channel";
parameter Real n1(unit = "-") = 0.03 "Manning coefficient";

//Subsection-2: Light brush
parameter Real l(unit = "m") = 8 "Length of the channel";
parameter Real w2(unit = "m") = 2 "Width of the channel";
parameter Real n2(unit = "-") = 0.05 "Manning coefficient";

//=================
//Variable Section 
Real A_c1(unit = "m2") "Area of subsection-1";
Real A_c2(unit = "m2") "Area of subsection-2";
Real A_c(unit = "m2") "Area of entire channel";
Real p1(unit = "m") "Perimeter of subsection-1";
Real p2(unit = "m") "Perimeter of subsection-2";
Real p(unit = "m") "Perimeter of entire channel";
Real Rh1(unit = "m") "Hydraulic radius of subsection-1";
Real Rh2(unit = "m") "Hydraulic radius of subsection-2";
Real Rh(unit = "m") "Hydraulic radius of entire channel";
Real v_1(unit = "m3/s") "Flow rate of subsection-1";
Real v_2(unit = "m3/s") "Flow rate of subsection-2";
Real v(unit = "m3/s") "Flow rate of entire channel";
Real n_eff(unit = "-") "Effective Manning coefficient for the entire channel";
Real s(unit = "m") "Side length of the triangular channel";

//=================
//Equation Section 
equation 
s = sqrt((h1^2)+(h1^2));
//Subsection-1: Clean natural channel 
A_c1 = (1/2*(w1*h1))+(w1*h2);
p1 = (h2+w1)+(s/2);
Rh1 = A_c1/p1;

//Subsection-2: Light brush
A_c2 = l*w2;
p2 = l+w2;
Rh2 = A_c2/p2;

//Entire Channel
A_c = A_c1 + A_c2;
p = p1+p2;
Rh = A_c/p;

//From Manning equation
v_1 = (a/n1)*(A_c1)*(Rh1^(2/3))*(S0^(1/2));
v_2 = (a/n2)*(A_c2)*(Rh2^(2/3))*(S0^(1/2));
v = v_1+v_2;
n_eff = (a*A_c*(Rh^(2/3))*(S0^(1/2)))/v;

end Ex13_4;
//==================
