//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-13: Open-Channel Flow
//Example 13.7 Page 764
//Title: Classification of Channel Slope

model Ex13_7

//=================
//Parameter Section
parameter Real y(unit = "m") = 2 "Flow depth of water";
parameter Real b(unit = "m") = 6 "Channel width";
parameter Real S0(unit = "-") = 0.004 "Bottom  slope";
parameter Real n(unit = "-") = 0.014 "Manning coefficient for an open channel with unfinished-concrete surfaces";
parameter Real a(unit = "m^(1/3)/s") = 1 "Dimensional constant";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real A_c(unit = "m2") "Cross-sectional area";
Real p(unit = "m") "Perimeter";
Real Rh(unit = "m") "Hydraulic radius";
Real v(unit = "m3/s") "Flow rate of water";
Real y_n(unit = "m") "Depth of flow";
Real y_c(unit = "m") "Critical depth of flow";
String Channel_Classification;

//=================
//Equation Section 
equation 
A_c = y*b;
p = b+(2*y);
Rh = A_c/p;
v = (a/n)*(A_c*(Rh^(2/3))*(S0^(1/2)));
y = y_n; //Since the flow is uniform
y_c = v^2/(g*(A_c^2));

//Channel Classification
if y_n<y_c then
Channel_Classification = "Steep";
else 
Channel_Classification = "Mild";
end if;

Modelica.Utilities.Streams.print(Channel_Classification);  

end Ex13_7;
//==================
