//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.1 Page 799
//Title: Operating Point of a Fan in a Ventilation System

model Ex14_1
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real D(unit = "m") = 0.23 "Inner diameter of the duct";
parameter Real L(unit = "m") = 13.4 "Total length";
parameter Real nE(unit = "-") = 5 "Number of elbows";
parameter Real k_L1(unit = "-") = 0.21 "Loss coefficient of elbow";
parameter Real k_L2(unit = "-") = 1.3 "Entry loss coefficinet";
parameter Real k_L3(unit = "-") = 1.8 "Loss coefficient when damper is fully open";
parameter Real alpha(unit = "-") = 1.05 "Kinetic friction factor";
parameter Real f(unit = "-") = 0.0209 "Friction factor";
parameter Real g(unit = "m/s2") =9.81 "Gravitational constant";
parameter Real v_actual(unit = "cfm") = 650 "Actual volume flow rate in ventilation system";

//From Table 14-1, Page no.800
//Adding 600 cfm to the tabulation data, since book trial calculation is based on 600 cfm
parameter Real [7] v(each unit = "ft3/min") = {0,250,500,600,750,1000,1200}"Volume flow rate through the duct";
parameter Real [7] H_available(each unit = "inches H2O") = {0.9,0.95,0.9,0.85,0.75,0.4,0}"Available net head of the fan";

//Properties of air estimated at 25 C
parameter Real kv(unit = "m2/s") = 1.562*0.00001 "Kinematic viscosity of air";
parameter Real Rho_a(unit = "kg/m3") = 1.184 "Density of air";
parameter Real Rho_w(unit = "kg/m3") = 998 "Density of water";

//=================
//Variable Section 
Real [7] Re(each unit = "-") "Reynolds number";
Real [7] H_req_a(each unit = "m of air") "Required net head of the fan at the minimum flow rate";
Real [7] H_req_w(each unit = "inches of water") "Equivalent column height of water";
Real k_L(unit = "-") "Sum of loss coefficient";
Real [7] V(each unit = "m/s") "Air speed through the duct";
Real v_operating(unit = "cfm") "Volume flow rate obtained from operating point in plot";
String Analysis;

//=================
//Equation Section 
equation 

k_L = (nE*k_L1)+k_L2+k_L3;

for i in 1:7 loop

Re[i] = (4*(v[i]/2118))/(kv*pi*D);
V[i] = Re[i]*kv/D;
H_req_a[i] = (alpha+(f*L/D)+k_L)*(V[i]^2/(2*g));

H_req_w[i] = H_req_a[i]*(Rho_a/Rho_w)*(1/0.0254);
//Dividing by 0.0254 to convert m to inch

end for;

/* From the Plot between volume flow rate vs H_available and H_req
The operating point is at a volume flow rate of about 650 cfm, 
at which both the required and available net head equal about
0.83 inches of water */

v_operating = 650;

//Checking condition what happens if the hole is drilled at some elevation in the tube    
if v_actual == v_operating then
Analysis = "The chosen fan is more than adequate for the job";
else
Analysis = "The chosen fan is not adequate for the job";
end if;

Modelica.Utilities.Streams.print(Analysis);                      

end Ex14_1;
//==================
