//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.15 Page 863
//Title: Application of Turbine Affinity Laws

model Ex14_15

//=================
//Parameter Section
//Existing turbine - A , New Turbine - B
parameter Real Rho_w(unit = "kg/m3") = 998 "Density of water at T = 20 C";
parameter Real D_A(unit = "m") = 2.05 "Diameter of Existing turbine A";
parameter Real H_A(unit = "m") = 75 "Net head of turbine A";
parameter Real H_B(unit = "m") = 104 "Net head of turbine B";
parameter Real n_A(unit = "rpm") = 120 "Speed of turbine A";
parameter Real n_B(unit = "rpm") = 120 "Speed of turbine B";
parameter Real v_A(unit = "m3/s") = 350 "Flowrate of water in turbine A";
parameter Real bhp_A(unit = "MW") = 242 "Horsepower of turbine A";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real D_B(unit = "m") "Diameter of new turbine B";
Real v_B(unit = "m3/s") "Flowrate of water in turbine B";
Real bhp_B(unit = "MW") "Horsepower in Turbine B";
Real Eff_B(unit = "-") "Efficiency of Turbine B";
Real Eff_A(unit = "-") "Efficiency of Turbine A";

//=================
//Equation Section 
equation
D_B = D_A*sqrt((H_B*n_A)/(H_A*n_B));
v_B = v_A*(n_B/n_A)*(D_B/D_A)^3;
bhp_B = bhp_A*(Rho_w/Rho_w)*(n_B/n_A)^3*(D_B/D_A)^5;

Eff_A = (bhp_A*10^6/(Rho_w*g*H_A*v_A)); 
//Multiplying by 10^6 to convert MW to W

Eff_B = 1-((1-Eff_A)*((D_A/D_B)^(1/5)));

end Ex14_15;
//==================
