//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.4 Page 812
//Title: Volume Flow Rate through a Positive-Displacement Pump

model Ex14_4

//=================
//Parameter Section
parameter Real n(unit = "-") = 0.5 "Number of rotations"; //From Figure 14-27 for 180 degree
parameter Real s(unit = "rpm") = 900 "Rotational speed"; 
parameter Real V_lobe(unit = "cm3") = 0.45 "Volume of the lobe";

//=================
//Variable Section 
Real v(unit = "cm3/min") "Volume flow rate of oil";
Real V_closed(unit = "cm3") "Total volume of the oil pumped";

//=================
//Equation Section 
equation 
V_closed = 2*V_lobe;
v = s*V_closed/n;

end Ex14_4;
//==================
