//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.8 Page 829
//Title:Design of a Vane-Axial Flow Fan for a Wind Tunnel

model Ex14_8
extends Modelica.Constants;
extends Modelica.Math;

//=================
//Parameter Section
parameter Real V_in(unit = "m/s") = 47.1 "Axial-flow speed through the blades";
parameter Real beta_sl(unit = "degree") = 0 "Angle of leading edge each stator blade";
parameter Real beta_st(unit = "degree") = 60 "Angle of trailing edge each stator blade";
parameter Real omega(unit = "rpm") = 1750 "Rotational speed of the impeller";
parameter Real r(unit = "m") = 0.4 "Radius of the impeller";

//=================
//Variable Section 
Real beta_rt(unit = "degree") "Trailing edge of the rotor";
Real beta_rl(unit = "degree") "Leading edge of the rotor";
Real u_theta(unit = "m/s") "Tangential velocity of the rotor blades";
Real V_st(unit = "m/s") "Velocity leaving the trailing edge of the stator";

//=================
//Equation Section 
equation

/*Multiplying beta by (180/pi) to convert rad to degree
and (pi/180) to convert degree to radian*/

V_st = V_in/(cos(beta_st*(pi/180)));
u_theta = omega*r*2*pi/60; 
//Dividing omega by 60 to convert rpm to rps

beta_rl = ((atan(((u_theta)+(V_in*tan(beta_st*(pi/180))))/(V_in)))*(180/pi));
beta_rt = ((atan(u_theta/V_in))*(180/pi));

//Number of rotor blades can be chosen as 13,15,17.

end Ex14_8;
//==================
