//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-14: Turbomachinery
//Example 14.9 Page 834
//Title: Using Pump Specific Speed for Preliminary Pump Design

model Ex14_9

//=================
//Parameter Section
parameter Real n(unit = "rpm") = 1170 "Rotational speed of shaft";
parameter Real v(unit = "gpm") = 320 "Flow rate of gasoline";
parameter Real H(unit = "ft") = 23.5 "Net head of gasoline";

//=================
//Variable Section 
Real N_sp_US(unit = "-") "Pump specific speed in customary U.S. units";
Real N_sp(unit = "-") "Pump specific speed";
String Best_Choice;

//=================
//Equation Section 
equation
N_sp_US = (n*(v^(1/2)))/(H^(3/4));
N_sp = N_sp_US*3.658*0.0001; 
//conversion factor to convert US unit

//Choice of Pump
if N_sp<1.5 then
Best_Choice = "Centrifugal Pump";
else
Best_Choice = "Axial or Mixed flow pump";
end if;

Modelica.Utilities.Streams.print(Best_Choice);

end Ex14_9;
//==================
