//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-2: Properties of Fluids  
//Example 2.3  Page 48 
//Title: Variation of Density with Temperature and Pressure 

package Ex2_3
model Ex2_3_a

//=================
//Parameter Section
parameter Real T1(unit = "C") = 20 "Initial temperature";
parameter Real T2(unit = "C") = 50 "Final temperature";
parameter Real P(unit = "atm") = 1 "Constant Pressure";
parameter Real rho_1(unit = "kg/m3") = 998.0 "Density of water at initial temperature and pressure";
parameter Real beta(unit = "K^-1") = 0.337*0.001 "Coefficient of volume expansion"; 
               //beta is taken from Figure 2-16, Page : 46

//==================
//Variable Section
Real del_rho_a(unit = "kg/m3") "Change in density";
Real rho_2a(unit = "kg/m3") "Final Density due to the change of temperature at constant pressure";

//==================
//Equation Section
equation 
del_rho_a = -(beta*rho_1*(T2-T1));
rho_2a = del_rho_a + rho_1;

end Ex2_3_a;

//==================

model Ex2_3_b
extends Ex2_3_a;

//==================
//Parameter Section
parameter Real P1(unit = "atm")=1 "Initial Pressure";
parameter Real P2(unit = "atm")=100 "Final Pressure";
parameter Real alpha(unit = "atm^-1")=4.80*0.00001 "isothermal compressibility of water";

//==================
//Variable Section
Real del_rho_b(unit = "kg/m3") "Change in density";
Real rho_2b(unit = "kg/m3") "Final Density due to the change of pressure at constant temperature";

//==================
//Equation Section
equation 
del_rho_b = (alpha*rho_1*(P2-P1));
rho_2b = del_rho_b + rho_1;

end Ex2_3_b;

//==================

end Ex2_3;

//==================
