//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.10  Page 102 
//Title: Measuring Specific Gravity by a Hydrometer

model Ex3_10_b
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real Rho_w(unit = "kg/m3") = 1000  "Density of water";
parameter Real D(unit = "cm") = 1 "Diameter of the hydrometer";
parameter Real L(unit = "cm") = 20 "Length of hydrometer";
parameter Real h(unit = "cm") = 10 "Position of hydrometer if it floats half way in pure water";

//=================
//Variable Section 
Real V(unit = "m3") "Volume of the hydrometer";
Real R(unit = "m") "Radius of the hydrometer";
Real m(unit = "kg") "Mass of lead that must be poured into the hydrometer";

//=================
//Equation Section
equation 
R = (D*0.01)/2; 
//Multiplying D by 0.01 to convert cm to m

V = pi*(R^2)*(h*0.01); 
//Multiplying h by 0.01 to convert cm to m
m = Rho_w*V;

end Ex3_10_b;
//=================
