//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.3  Page 85 
//Title: Measuring Atmospheric Pressure with a Barometer

model Ex3_3

//=================
//Parameter Section
parameter Real P(unit = "mm hg") = 740 "Barometric pressure reading";
parameter Real g(unit = "m/s2") = 9.805 "Gravitational constant";
parameter Real Rho(unit = "kg/m3")= 13570 "Density of mercury";

//=================
//Variable Section 
Real Patm(unit = "kPa") "Atmospheric pressure at a location";
Real h(unit ="m") "Height";

//=================
//Equation Section
equation 
h = P/1000;
Patm = (Rho*g*h)/1000; 
//Patm is divided by 1000 to convert it to kPa

end Ex3_3;
//=================
