//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-3: Pressure and Fluid Statics   
//Example 3.8  Page 96 
//Title: Hydrostatic Force Acting on the Door of a Submerged Car

model Ex3_8

//=================
//Parameter Section
parameter Real b(unit = "m") = 1.2  "Height of the door";
parameter Real w(unit = "m") = 1 "Width of the door";
parameter Real s(unit = "m") = 8 "Top edge of the door";
parameter Real Rho_w(unit = "kg/m3") = 1000 "Density of lake water";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//=================
//Variable Section 
Real Pgage(unit = "kPa") "Gage pressure on the door";
Real F_R(unit = "kN") "Resultant hydrostatic force on the door";
Real y_p(unit = "m") "Location of the pressure center";
Real A(unit = "m2") "Area";

//=================
//Equation Section
equation 
Pgage = (Rho_w*g*(s+(b/2)))/1000; 
//Pgage is divided by 1000 to convert it to kPa

A = b*w;
F_R = Pgage*A;
y_p = s+(b/2)+(b^2/(12*(s+(b/2))));

end Ex3_8;
//=================
