//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-4: Fluid Kinematics   
//Example 4.3 Page 144
//Title: Material Acceleration of a Steady Velocity Field

package Ex4_3
model Ex4_3_a

//=================
//Parameter Section
parameter Real x(unit = "m") = 2 "Point-1";
parameter Real y(unit = "m") = 3 "Point-2";

/*Input given in vector form from Ex4_1

V = (u,v) = (0.5+0.8x)i + (1.5-0.8y)j

*/
//=================
//Variable Section 
Real a_x(unit = "m/s2") "Non zero component of acceleration vector";
Real a_y(unit = "m/s2") "Non zero component of acceleration vector";

//=================
//Equation Section
equation 
a_x = 0.4+0.64*x;
a_y = -1.2+0.64*y;

end Ex4_3_a;


//=================

model Ex4_3_b

//=================
//Parameter Section

//Input data is given as array for plotting
parameter Real [6] x_array(each unit = "m") = {-3,-2,-1,1,2,3} "Array of x values";
parameter Real [6] y_array(each unit = "m") = {-1,1,2,3,4,5} "Array of y values";

//=================
//Variable Section 
Real [6] a_x_array(each unit = "m/s2") "Non zero component of acceleration vector";
Real [6] a_y_array(each unit = "m/s2") "Non zero component of acceleration vector";

//=================
//Equation Section
equation 

//To find the non zero components of acceleration vector using array of x and y values

for i in 1:6 loop
a_x_array[i] = 0.4+0.64*x_array[i];
a_y_array[i] = -1.2+0.64*y_array[i];
end for;

end Ex4_3_b;

//=================

end Ex4_3;

//=================
