//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.15  Page 232
//Title: Pumping Water from a Lake to a Pool

model Ex5_15

//=================
//Parameter Section
parameter Real W_shaft(unit = "kW") = 5 "Shaft power delivered by the pump";
parameter Real Eff_pump(unit = "%") = 72 "Efficiency of the pump";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real hL(unit = "m") = 4 "Irreversible head loss in the piping system";
parameter Real z2(unit = "m") = 25 "Elevation at the free surface of the pool";
parameter Real z1(unit = "m") = 0 "Elevation at the free surface of the lake";
                                 //Reference level is taken as point 1
parameter Real Rho_w(unit = "kg/m3") = 1000 "Density of water";

//=================
//Variable Section 
Real m(unit = "kg/s") "Mass flow rate of water";
Real V(unit = "L/s") "Volume flow rate of water";
Real del_P(unit = "kPa") "Pressure difference across the pump";
Real W_pump(unit = "kW") "Mechanical power it imparts to the water";

//=================
//Equation Section 
equation 
//Reduction of energy equation
W_pump = W_shaft*(Eff_pump/100); 
m = (W_pump/(g*(z2+hL)))*1000;
V = (m/Rho_w)*10^3;
//V multiplied by 10^3 to convert m3/s to L/s

del_P = W_pump/(V*0.001);
//V multiplied by 0.001 to convert L/s to m3/s

end Ex5_15;

//=================
