//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.2  Page 197
//Title:  Discharge of Water from a Tank

model Ex5_2

//=================
//Parameter Section
parameter Real h0(unit = "feet") = 4 "Initial level of water in the tank";
parameter Real h2(unit = "feet") = 2 "Drop in water level in the tank";
parameter Real D_tank(unit = "feet") = 3 "Diameter of the tank";
parameter Real D_jet(unit = "inch") = 0.5 "Diameter of the jet";
parameter Real g(unit = "ft/s2") = 32.2 "Gravitational constant";

//=================
//Variable Section 
Real t(unit = "s") "time of discharge";
Real t_c(unit = "min") "converted time from second to minute";

//=================
//Equation Section 
equation 
t= ((sqrt(h0)-sqrt(h2))/sqrt(g/2))*((D_tank*12/D_jet)^2); 
//Multiplying D_tank by 12 to convert feet to inch
t_c = t/60;

end Ex5_2;
//==================
