//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.7  Page 213
//Title: Siphoning Out Gasoline from a Fuel Tank

package Ex5_7
model Ex5_7_a
extends Modelica.Constants;

//=================
//Parameter Section
//From Figure 5-41, Page No.213
parameter Real z1(unit = "m") = 0.75 "location of point 2";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real D(unit = "mm") = 5 "Diameter of siphon";
parameter Real V(unit = "L") = 4 "Volume of gasoline";

//=================
//Variable Section 
Real V2(unit = "m/s") "velocity at the outlet";
Real A(unit = "m2") "Cross-sectional area of the tube";
Real v(unit = "L/s") "Flow rate of gasoline";
Real del_t(unit = "s") "time needed to siphon gasoline";

//=================
//Equation Section 
equation 
V2 = sqrt(2*z1*g);
A = (pi/4)*(D*0.001)^2; 
//Multiplying D by 0.001 to convert mm to m

v = V2*A*10^3; 
//Multiplying by 10^3 to convert m3/s to L/s

del_t = V/v;

end Ex5_7_a;
//==================
model Ex5_7_b
extends Ex5_7_a;

//=================
//Parameter Section
parameter Real z3(unit = "m") = 2 "Location of point 3 above point 1";
parameter Real Rho(unit = "kg/m3") = 750 "Density of gasoline";
parameter Real Patm(unit = "kPa") = 101.3 "Atmospheric pressure";

//=================
//Variable Section 
Real P3(unit = "kPa") "Pressure at point 3";
Real z3_t(unit = "m") "Total height";

//=================
//Equation Section 
equation 
z3_t = z3+z1;

//Reduced form of Bernoulli equation
P3 = Patm - ((Rho*g*z3_t)/1000); 
//Dividing P3 by 1000 to convert Pa to kPa

end Ex5_7_b;

//==================

end Ex5_7;

//==================
