//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-5: Bernoulli and Energy Equations   
//Example 5.9  Page 216
//Title:  The Rise of the Ocean Due to a Hurricane

package Ex5_9
model Ex5_9_a

//=================
//Parameter Section
parameter Real Rho_hg(unit = "lbm/ft3") = 848 "Density of mercury";
parameter Real Rho_sw(unit = "lbm/ft3") = 64 "Density of sea water";
parameter Real Patm_air(unit = "in Hg") = 30 "Atmospheric pressure at point 1 , normal for the ocean";
parameter Real P_air(unit = "in Hg") = 22 "Atmospheric pressure at eye of storm";

//=================
//Variable Section 
Real h_3(unit = "ft") "Atmospheric pressure at point 3 , eye of hurricane";
Real h_Hg(unit = "in Hg") "Mercury column height";

//=================
//Equation Section 
equation 
h_Hg = Patm_air - P_air;
h_3 = ((Rho_hg/Rho_sw)*(h_Hg))/12; 
//Reduced equation of Del_P = Rho*g*h
//Dividing h by 12 to convert ft to in

end Ex5_9_a;

//==================
model Ex5_9_b
extends Ex5_9_a;

//=================
//Parameter Section
parameter Real Rho_a(unit = "lbm/ft3") = 0.076 "Density of air at normal sea-level temperature and pressure";
parameter Real Vw(unit = "mph") = 155 "Wind velocity";
parameter Real g(unit = "ft/s2") = 32.2 "Gravitational constant";

//=================
//Variable Section 
Real PH(unit = "ft") "Pressure head"; //(P_B-P_A)/Rho*g
Real Rho_ah(unit = "lbm/ft3") "Density of the air in hurricane";
Real h_dynamic(unit = "ft") "Sea water column height";
Real h_air(unit = "ft") "Air column height";
Real h_2(unit = "ft") "Total storm surge at point 2";

//=================
//Equation Section 
equation 
PH = ((Vw^2)/(2*g))*((1.4667/1)^2); 
//Multiplying by 1.4667 to convert mph to ft

h_air = PH;
Rho_ah = (P_air / Patm_air)*(Rho_a);
h_dynamic = (Rho_ah/Rho_sw)*h_air;
h_2 = h_3 + h_dynamic;

end Ex5_9_b;

//==================

end Ex5_9;

//==================
