//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-6: Momentum Analysis of flow systems 
//Example 6.6 Page 266 
//Title: Deceleration of a Spacecraft

package Ex6_6
model Ex6_6_a

//=================
//Parameter Section
parameter Real m_spacecraft(unit = "kg") = 12000 "Mass of spacecraft";
parameter Real m_gas(unit = "kg/s") = 80 "Mass flow rate of gas";
parameter Real V_gas(unit = "m/s") = 3000 "Velocity of gas";

//=================
//Variable Section 
Real a_spacecraft(unit = "m/s2") "Deceleration of the spacecraft";

//=================
//Equation Section
equation 
a_spacecraft = -(m_gas/m_spacecraft)*V_gas;

end Ex6_6_a;

//=================

model Ex6_6_b
extends Ex6_6_a;

//=================
//Parameter Section
parameter Real del_T(unit = "s") = 5 "Time period";

//=================
//Variable Section 
Real del_V(unit = "m/s") "Velocity change of the spacecraft";

//=================
//Equation Section
equation 
del_V = a_spacecraft*del_T;

end Ex6_6_b;

//=================

model Ex6_6_c
extends Ex6_6_b;
extends Ex6_6_a;

//=================
//Variable Section 
Real F_thrust(unit = "kN") "Thrusting force exerted on the space aircraft";

//=================
//Equation Section
equation 
F_thrust = -(m_gas*V_gas)/1000; 
//Dividing F_thrust by 1000 to convert N to kN

end Ex6_6_c;

//=================

end Ex6_6;

//=================
