//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-6: Momentum Analysis of flow systems 
//Example 6.8 Page 277 
//Title: Bending Moment Acting at the Base of a Water Pipe

model Ex6_8
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real Rho_w(unit = "kg/m3") = 1000 "Density of water";
parameter Real D(unit = "cm") = 10 "Diameter of the pipe";
parameter Real V(unit = "m/s") = 3 "Average velocity of water";
parameter Real mass(unit = "kg/m") = 12 "Mass of the horizontal pipe section per meter length";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";
parameter Real r2(unit = "m") = 2 "Vertical length of the pipe";
parameter Real r1(unit = "m") = 1 "Horizontal length of the pipe";

//=================
//Variable Section 
Real A(unit = "m2") "Area of the pipe";
Real m(unit = "kg/s") "Mass flow rate of water";
Real W(unit = "N") "Weight of the horizontal section of the pipe";
Real M_A(unit = "N.m") "Angular momentum along A";
Real L(unit = "m") "Length of the horizontal section";

//=================
//Equation Section
equation 
A = (pi/4)*(D*0.01)^2; 
//Multiplying D by 0.01 to convert cm to m

m = Rho_w*A*V;
W = mass*g;
M_A = ((r1/2)*W)-(r2*m*V);
L = sqrt((2*r2*m*V)/(W/r1));

end Ex6_8;
//=================
