//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-6: Momentum Analysis of flow systems 
//Example 6.9 Page 278 
//Title: Power Generation from a Sprinkler System

model Ex6_9
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real Rho_w(unit = "kg/m3") = 1000 "Density of water";
parameter Real v_total(unit = "L/s") = 20 "Total volumetric flow rate of water";
parameter Real n(unit = "rpm") = 300 "Sprinkler rate in a horizontal plane";
parameter Real D_jet(unit = "cm") = 1 "Diameter of each jet";
parameter Real r(unit = "m") = 0.6 "Distance between the axis of rotation and the center of each nozzle";
parameter Real n_arm(unit = "-") = 4 "Number of identical arms in the sprinkler";

//=================
//Variable Section 
Real v_nozzle(unit = "L/s") "Volumeteric flow rate of water through each nozzle";
Real V_jet_r(unit = "m/s") "Average jet exit velocity relative to the rotating nozzle";
Real A_jet(unit = "m2") "Area of each jet";
Real m_total(unit = "kg/s") "Total mass flow rate of water";
Real omega(unit = "rad/s") "Angular velocity of the nozzle";
Real V_nozzle(unit = "m/s") "Tangential velocity of the nozzle";
Real V_jet(unit = "m/s") "Average absolute velocity of the water jet";
Real T_shaft(unit = "N.m") "Torque transmitted through the shaft";
Real W(unit = "kW") "Electric power generated";

//=================
//Equation Section
equation 
v_nozzle = (v_total/1000)/n_arm; 
//Dividing v_total by 1000 to convert L/s to m^s/s

A_jet = (pi/4)*(D_jet*0.01^2);
V_jet_r = v_nozzle/A_jet;

omega = (2*pi*n)/60; 
//Dividing n by 60 convert rpm to rps

V_nozzle = r*omega;
V_jet = V_jet_r - V_nozzle;

m_total = (Rho_w/1000)*v_total; 
//Dividing Rho_w by 1000 to convert kg/m3 to kg/L

T_shaft = r*m_total*V_jet;

W = (omega*T_shaft)/1000; 
//Dividing W by 1000 to convert W to kW

end Ex6_9;
//=================
