//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-8: Internal Flow
//Example 8.10 Page 393 
//Title: Effect of Flushing on Flow Rate from a Shower

package Ex8_10
model Ex8_10_a
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real D(unit = "cm") = 1.5 "Diameter of the pipe";
parameter Real g(unit = "m/s2") = 9.81 "Gravitational constant";

//From Figure 8-53, Page No.393
parameter Real KL_valve(unit = "-") = 10 "Loss coeffecient at the fully open globe valve";
parameter Real KL_shower_head(unit = "-") = 12 "Loss coeffecient at the shower head";
parameter Real KL_tee(unit = "-") = 0.9 "Loss coeffecient at the tee";
parameter Real KL_elbow(unit = "-") = 0.9 "Loss coeffecient at the standard elbows";
parameter Real nE(unit = "-") = 2 "Number of elbow";
parameter Real P_gage(unit = "kPa") = 200 "Gage pressure";
parameter Real L(unit = "m") = 11 "Length of the whole section";
parameter Real del_Z(unit = "m") = 2 "Height";

//Properties of water determined at 20 C
parameter Real Rho_w(unit = "kg/m3") = 998 "Density of water";
parameter Real mu_w(unit = "kg/m.s") = 1.002*0.001 "Dynamic viscosity of water";
parameter Real ep(unit = "m") = 1.5*0.000001 "Roughness of copper pipes"; 

//=================
//Variable Section 
Real V(unit = "m/s") "Average velocity in the pipe"; 
Real v(unit = "m3/s") "Volume flow rate";
Real Re(unit = "-", start = 10000) "Reynolds number";
Real f(unit = "-", start = 0.01) "Friction factor";
Real KL_sum(unit = "-") "Sum of loss coefficients";
Real h_L(unit = "m") "Total head loss";
Real kv(unit = "m2/s") "Kinetic viscosity";
Real v_c(unit = "L/s") "Volume flow rate";

//=================
//Equation Section
equation 
KL_sum = KL_tee + (2*KL_elbow) + KL_valve + KL_shower_head;

h_L = ((P_gage*10^3)/(Rho_w*g))-(del_Z);
//Multiplying P_gage by 10^3 to convert kPa to Pa

h_L = ((f*(L/(D*0.01)))+(KL_sum))*((V^2)/(2*g));
kv = mu_w/Rho_w;
V = v/((pi/4)*(D*0.01)^2);
Re = (V*(D*0.01))/(kv);
//Multiplying D by 0.01 to convert cm to m

//Colebrook equation 
1 / sqrt(f) = (-2) * log10(ep / D * 0.01 / 3.7 + 2.51 / (Re * sqrt(f)));

//Converting v from m3/s to L/s
v_c = v*1000;

end Ex8_10_a;


//=================

model Ex8_10_b
extends Modelica.Constants;
extends Ex8_10_a;

//=================
//Parameter Section
parameter Real del_Z2(unit = "m") = 1 "Height";

//From Figure 8-53, Page No.393
parameter Real KL_valve(unit = "-") = 10 "Loss coeffecient at the fully open globe valve";
parameter Real KL(unit = "-") = 2 "Loss coeffecient";
parameter Real KL_tee(unit = "-") = 0.9 "Loss coeffecient at the tee";
parameter Real KL_reservoir(unit = "-") = 14 "Loss coeffecient at reserviour";
parameter Real L_s1(unit = "m") = 5 "Length of the First section";
parameter Real L_s2(unit = "m") = 4 "Length of the Second section";
parameter Real L_s3(unit = "m") = 1 "Length of the Third section";

//=================
//Variable Section 
Real V1(unit = "m/s") "Average velocity in the pipe in section 1"; 
Real V2(unit = "m/s") "Average velocity in the pipe in section 2"; 
Real V3(unit = "m/s") "Average velocity in the pipe in section 3"; 
Real v1(unit = "m3/s") "Volume flow rate in section 1";
Real v2(unit = "m3/s") "Volume flow rate in section 2";
Real v3(unit = "m3/s") "Volume flow rate in section 3";
Real Re1(unit = "-", start = 10000) "Reynolds number in section 1";
Real Re2(unit = "-", start = 10000) "Reynolds number in section 2";
Real Re3(unit = "-", start = 10000) "Reynolds number in section 3";
Real f1(unit = "-", start = 0.01) "Friction factor in section 1";
Real f2(unit = "-", start = 0.01) "Friction factor in section 2";
Real f3(unit = "-", start = 0.01) "Friction factor in section 3";
Real KL_sum_2(unit = "-") "Sum of loss coefficients in section 2";
Real KL_sum_3(unit = "-") "Sum of loss coefficients in section 3";
Real h_L2(unit = "m") "Total head loss in section 2";
Real h_L3(unit = "m") "Total head loss in section 3";
Real Change_Percentage(unit = "%") "Percentage Change of flow rate of cold water through shower when flushing";

//=================
//Equation Section
equation 

//Due to parallel flow after the tee connection
h_L2 = h_L;
KL_sum_2 = KL_sum;

h_L3 = ((P_gage*10^3)/(Rho_w*g))-(del_Z2);
KL_sum_3 = KL_valve + KL + KL_tee + KL_reservoir;


//Solving 12 Equations to find 12 Unknowns
v1 = v2 + v3;
h_L2 = (f1*(L_s1/(D*0.01))*((V1^2)/(2*g)))+(((f2*(L_s1/(D*0.01))) + KL_sum_2)*((V2^2)/(2*g)));
h_L3 = (f1*(L_s1/(D*0.01))*((V1^2)/(2*g)))+(((f3*(L_s3/(D*0.01))) + KL_sum_3)*((V3^2)/(2*g)));
V1 = v1/((pi/4)*((D*0.01)^2));
V2 = v2/((pi/4)*((D*0.01)^2));
V3 = v3/((pi/4)*((D*0.01)^2));
Re1 = (V1*D*0.01)/kv;
Re2 = (V2*D*0.01)/kv;
Re3 = (V3*D*0.01)/kv;
//Multiplying D by 0.01 to convert cm to m

//Colbroke Equation
1 / sqrt(f1) = (-2) * log10(ep / D * 0.01 / 3.7 + 2.51 / (Re1 * sqrt(f1)));
1 / sqrt(f2) = (-2) * log10(ep / D * 0.01 / 3.7 + 2.51 / (Re2 * sqrt(f2)));
1 / sqrt(f3) = (-2) * log10(ep / D * 0.01 / 3.7 + 2.51 / (Re3 * sqrt(f3)));

//Percentage Change of flow rate of cold water through shower when flushing 
Change_Percentage = ((v-v2)/v2)*100;


end Ex8_10_b;

//=================

end Ex8_10;

//=================

