//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-1: Introduction and basic concepts 
//Example 1.6  Page 31 
//Title: Significant Digits and Volume Flow Rate

model Ex1_6

//=================
//parameter Section
parameter Real dv(unit = "gal") = 1.1 "Volume of water collected";
parameter Real dt(unit = "s") = 45.62 "Time Period";

//=================
//Variable Section
Real V(unit = "m3/min") "Volume Flow Rate";

//=================
//Equation Section 
equation
V=((dv/dt)*(0.0037854/1)*(60)); //Volume Flow Rate of water
/*V multiplied by 3.7854*10^-3 to convert gal/s to m3/s
V multiplied by 60 to convert m3/s to m3/min */

end Ex1_6;
//=================
