//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-10: Approximate Solutions of the Navier-Stokes Equation
//Example 10.8 Page 554
//Title: Flow into a Vacuum Cleaner Attachment

model Ex10_8
extends Modelica.Constants;

//=================
//Parameter Section
parameter Real v(unit = "m3/s") = 0.110 "Total Volume flow rate through the vacuum hose";
parameter Real L(unit = "cm") = 35 "Length of the hose";
parameter Real b(unit = "cm") = 2 "Distance of the slot above the floor";

//Array of x* to plot
parameter Real [11] x_s(each unit = "m/s") = {-5,-4,-3,-2,-1,0,1,2,3,4,5} "Normalized distance along the floor";

//=================
//Variable Section 
Real S(unit = "m2/s") "Strength of line source";
Real u_max(unit = "m/s") "Maximum speed along the floor";
Real u_star_max(unit = "m/s") "Normalised maximum speed along the floor";
Real [11] u_s(each unit = "m/s") "Non dimensional axial velocity";
Real [11] Cp(each unit = "-") "Pressure coefficient";
String Analysis;

//=================
//Equation Section
equation 
S = -v/(L*0.01);

//Generation of array values to plot and find Normalized distance along the floor
for i in 1:11 loop
u_s[i] = (-1/pi)*(x_s[i]/(1+(x_s[i]^2)));
Cp[i] = -((1/pi)*(x_s[i]/(1+(x_s[i]^2))))^2;
end for;

//u_star_max obtained from Plot
u_star_max = u_s[5];

u_max = -(u_star_max)*(S/(b*0.01));

/*vacuum cleaner is most effective at sucking up dirt from
the floor when the speed along the floor is greatest and the pressure along the
floor is lowes*/

//Analysis
if u_s[5]>Cp[5] then
Analysis = "Vacuum cleaner is most effective at sucking up dirt from
the floor when the speed along the floor is greatest and the pressure along the
floor is lowest";
else
Analysis = "Vacuum cleaner is not effective";
end if;

Modelica.Utilities.Streams.print(Analysis); 


end Ex10_8;
//=================
