//Y.A.Cengel and J.M.Cimbala, Fluid Mechanics:Fundamentals and Applications,4th Edition, McGraw-Hill Education, 2017

//Chapter-11: External Flow: Drag and Lift    
//Example 11.3  Page 632
//Title:  Drag Force on a Train Surface

model Ex11_3

//=================
//Parameter Section
parameter Real Rho_a(unit = "kg/m3") = 1.184 "Density of air at 1 atm, 25 C";
parameter Real v(unit = "m2/s") = 1.562*0.00001 "Kinematic viscosity of air at 1 atm, 25 C";
parameter Real V(unit = "km/h") = 95 "Velocity of the moving train";
parameter Real W(unit = "m") = 2.1 "Width of the surface of the passenger car of a train";
parameter Real L(unit = "m") = 8 "Length of surface of the passenger car of a train";

//=================
//Variable Section 
Real Re(unit = "-") "Reynolds number";
Real C_f(unit = "-") "Average friction coefficient";
Real C_D(unit = "-") "Drag coefficient";
Real F_D(unit = "N") "Drag force acting on the surface";
Real A(unit = "m2") "Area of the surface";

//=================
//Equation Section 
equation 
A = W*L;
Re = (V/3.6)*L/v; 
//Dividing V by 3.6 to convert km/h to m/s;

//To find the type of flow
if Re<5*10^5 then
C_f = 1.33/Re^(1/2); //Laminar
else
C_f = ((0.074/Re^(1/5)) - (1742/Re)); //Laminar and Turbulent
end if;

C_D = C_f ; 

//Pressure drag is zero and thus CD = Cf for a flat plate;
F_D = (C_f*A*Rho_a*(V/3.6)^2)/2;
 
end Ex11_3;
//==================
